<?php 
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */
    session_start(); // serve per valutare se mostrare o meno la barra amministrativa
    
    include "include/costanti.php";
    include "include/util.php";
    include "gUtil/DbManager.php";
    include "gUtil/ControlloreStringhe.php";
    include "gUtil/GestoreTraduzioni.php";
    include "classi/GeneratoreUrl.php";
    include "classi/GestoreJavascript.php";
    include "template/stile.php";
    include "template/include/includeClassiTemplate.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);	
    $gestoreJavascript = new GestoreJavascript();
    $datiBlog     = $geecomDb->leggiSingolaRiga("geec_blog", 1);
    $inclusioni   = recuperaInclusioni($geecomDb);
    $impostazioni = recuperaImpostazioni($geecomDb);
     
    if(ControlloreStringhe::rilevaMysql($_GET["tipoRicerca"]) || ControlloreStringhe::rilevaMysql($_GET["chiaveRicerca"])) {
        header("HTTP/1.0 400 Bad Request");
        $lingua = "italiano";
        echo"<title>Pagina non trovata</title>";
        include "include/includeCssBase.php"; 
        echo"<link rel=\"stylesheet\" type=\"text/css\" href=\"template/stile.css\">";
        include "template/include/templatePagine/404.php";
        include "include/includeJsBase.php";
        exit();
    }
    
    if ($impostazioni["manutenzione"]=="si" && !isset($_SESSION["geecomAdmin_email"])) {            
        header("Location: {$impostazioni["urlSito"]}");
        exit();
    }
    
    $profiliSocial = $geecomDb->leggiSingolaRiga("geec_profiliSocial",1);
        
    //nella pagina cerca la lingua del gestore traduzioni deve contenere tutte le lingue attive
    $impostazioniLingue  = $geecomDb->leggiSingolaRiga("geecB_impostazioniLingue",1);
    $lingueAttive = array();
    if($impostazioniLingue["impostazioniItaliano"]=="si") {
        array_push($lingueAttive,"italiano");
    }
    if($impostazioniLingue["impostazioniInglese"]=="si") {
        array_push($lingueAttive,"inglese");
    }
    if($impostazioniLingue["impostazioniTedesco"]=="si") {
        array_push($lingueAttive,"tedesco");
    }
    if($impostazioniLingue["impostazioniFrancese"]=="si") {
        array_push($lingueAttive,"francese");
    }
    if($impostazioniLingue["impostazioniSpagnolo"]=="si") {
        array_push($lingueAttive,"spagnolo");
    }
    
    $gestoreTraduzioni  = new GestoreTraduzioni("localizzazione", $lingueAttive);
    $gestoreTraduzioni->caricaTraduzioni();
    
    $impostazioniMotoreRicerca = $geecomDb->leggiSingolaRiga("geecB_impostazioniRicerca",1);
        
    if(isset($_GET["tipoRicerca"]) && isset($_GET["chiaveRicerca"])) {
        $tipoRicerca = $geecomDb->escapeString(htmlspecialchars($_GET["tipoRicerca"]));
        $chiaveRicerca       = strip_tags(filter_input(INPUT_GET,"chiaveRicerca",FILTER_SANITIZE_ADD_SLASHES)); // strip tag preveene inserimento di codice HTML, filter input previene SQL injection
        
        if($tipoRicerca=="categoria" || $tipoRicerca=="prodottiPerMarcaECategoria") {
            $categoria     = $geecomDb->leggiSingolaRiga("geec_categorie",$chiaveRicerca,"alias");
        }
        
        $risultatiPerPagina = 5;
        
        if(isset($_GET["pag"])) {
            $paginaCorrente = $_GET["pag"];
        }
        else {
            $paginaCorrente = 1;
        }
    }
    else if(isset($_GET["tipoRicerca"])) { // se è presente solo tipo ricerca (ad esempio quando è utilizzato per cercare qualcosa generato con dei componenti esterni)
        $tipoRicerca = $geecomDb->escapeString(htmlspecialchars($_GET["tipoRicerca"]));
    }
    
    // recupera lo stile scelto, la variabile aspettiSito è contenuta nel file stile.php
    $aspettoSito = $aspettiSito[$impostazioni["aspettoSito"]];
    
    $configurazioneAspetto = $geecomDb->leggiSingolaRiga("geec_configurazioniAspetto","si","selezionataCms");

    include "include/gestioneMultilingua.php";
    $datiCookie = $geecomDb->leggiSingolaRiga("geecB_leggeCookie",$lingua,"lingua");
    
    // inizializzo il motore di ricerca
    if(isset($categoria)) {
        $motoreRicerca = new MotoreDiRicercaTemplate($geecomDb, $tipoRicerca, $impostazioniMotoreRicerca, $categoria, $categoria["numeroArticoliPerPagina"], $datiBlog,$gestoreTraduzioni,$lingua);
    }
    else {        
        $motoreRicerca = new MotoreDiRicercaTemplate($geecomDb, $tipoRicerca, $impostazioniMotoreRicerca, $chiaveRicerca,$impostazioniMotoreRicerca["elementiPerPagina"],$datiBlog,$gestoreTraduzioni,$lingua);
    }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <?php 
        echo $inclusioni["inizioHead"]; 
        if(isset($_COOKIE["leggecookie"])) echo $datiCookie["headCodiciCookie"];
    ?>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <meta name="description" 
	<?php
            if($tipoRicerca=="tag") {
                $descrizione = "Articoli con tag: $chiaveRicerca";
                $titolo = "Articoli con tag: $chiaveRicerca";
            }
            else if($tipoRicerca=="autore") {
                $descrizione = "Articoli dell'autore: $chiaveRicerca";
                $titolo = "Articoli dell'autore: $chiaveRicerca";
            }
            else if($tipoRicerca=="categoria") {
                $descrizione = $categoria["metaDescrizione"];
                $titolo = $categoria["titoloPagina"];
            }
            else { // tipoRicerca = ricerca o altre parole generiche
                $descrizione = "Risultati con la parola chiave: $chiaveRicerca";
                $titolo = "Risultati con la parola chiave: $chiaveRicerca";
            }
	?>
	content="<?= $descrizione ?>"
    />

    <title><?= "$titolo" ?></title>

    <?php 
	include "include/includeCssBase.php"; 
        
        if($tipoRicerca=="categoria") {
            echo"<style type=text/css>
            {$categoria["cssGenerato"]}
            {$categoria["cssAggiuntivo"]}
            </style>";
        }
    ?>
</head>

<body class="<?php echo $aspettoSito["body"]; ?> <?php echo(($impostazioni["attivaBarraSuperiore"]=="si") ? "extraspace" : ""); ?>">
    <div class="thetop"></div>
    <?php 

        if(isset($_SESSION["geecomAdmin_email"])) {
            include "template/include/barraAdmin.php";
        }
            
        include"template/include/aspetto/{$aspettoSito["cartellaTemplatePagina"]}/templatePagina/pagineElencoArticoli.php"; 

        // contiene la modal sulla legge dei cookie, la ricerca fullscreen ed eventuali
        // aggiunte del tema
        include"template/include/elementiAggiuntiviTemplate.php";
            
        UtilTemplate::stampaScrollTop();
        
	include "include/includeJsBase.php";
        
        echo $inclusioni["fineBody"];
    ?>
</body>
</html>
